/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.RedMask;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;

public class TombRedMask
extends AbstractImageEvent {
    public static final String ID = "Tomb of Lord Red Mask";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Tomb of Lord Red Mask");
    public static final String NAME = TombRedMask.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = TombRedMask.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = TombRedMask.eventStrings.OPTIONS;
    private static final int GOLD_AMT = 222;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String MASK_RESULT = DESCRIPTIONS[1];
    private static final String RELIC_RESULT = DESCRIPTIONS[2];
    private CurScreen screen = CurScreen.INTRO;

    public TombRedMask() {
        super(NAME, DIALOG_1, "images/events/redMaskTomb.jpg");
        if (AbstractDungeon.player.hasRelic("Red Mask")) {
            GenericEventDialog.setDialogOption(OPTIONS[0]);
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[1], true);
            GenericEventDialog.setDialogOption(OPTIONS[2] + AbstractDungeon.player.gold + OPTIONS[3]);
        }
        GenericEventDialog.setDialogOption(OPTIONS[4]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    AbstractDungeon.effectList.add(new RainingGoldEffect(222));
                    AbstractDungeon.player.gainGold(222);
                    GenericEventDialog.updateBodyText(MASK_RESULT);
                    this.logMetric("Wore Mask");
                } else if (buttonPressed == 1) {
                    AbstractDungeon.player.loseGold(AbstractDungeon.player.gold);
                    this.logMetric("Paid");
                    AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, new RedMask());
                    GenericEventDialog.updateBodyText(RELIC_RESULT);
                } else if (buttonPressed == 2) {
                    this.openMap();
                    GenericEventDialog.clearAllDialogs();
                    GenericEventDialog.setDialogOption(OPTIONS[4]);
                    this.logMetric("Ignored");
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[4]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

